/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/


function getStack(n, e) {

	if (typeof e.stack == "undefined") {
		console.log(e);
		return null;
	} 

    var stacks = [];
    var stack = e.stack.split("\n");

    for (var i = 0, j = stack.length; i < j; i++) {
        var current = stack[i].match(/^(?:\s*at? ?)?(.+?)(?:@| )\(?(.*?):[^\/](\d*):?(\d*)?/);

        if (current == null) {
            continue;
        }

        var entry = {
            msg : e.message,
            fn: current[1] || "anonymous",
            file: current[2] || "unknown",
            line: ~~current[3],
            column: ~~current[4],
            time: new Date().getTime()
        };

        if ("getStack" !== entry.fn){
            stacks.push(entry);
        }
    }

    console.log("number" === typeof n ? stacks[n] : stacks);    
}